% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wand.r
\name{incant}
\alias{incant}
\title{Retrieve 'magic' attributes from files and directories}
\usage{
incant(path, magic_db = "system")
}
\arguments{
\item{path}{character vector of files to use magic on}

\item{magic_db}{either "\code{system}" (the default) to use the system
\code{magic} database or an atomic character vector with a
colon-separated list of full paths to custom \code{magic} database(s). This parameter
is (for the moment) ignored on Windows.}
}
\value{
a \code{tibble} / \code{data.frame} of file magic attributes.
  Specifically, mime type, encoding, possible file extensions and
  type description are returned as colums in the data frame along
  with \code{path}.
}
\description{
Retrieve 'magic' attributes from files and directories
}
\note{
Various fields might not be available depending on the version
  of \code{libmagic} you have installed.
}
\examples{
library(dplyr)

system.file("extdata/img", package="wand") \%>\%
  list.files(full.names=TRUE) \%>\%
  incant() \%>\%
  glimpse()
}
\references{
See \url{http://openpreservation.org/blog/2012/08/09/magic-editing-and-creation-primer/}
  for information on how to create your own \code{magic} database
}

