% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occs_queryDb.R
\name{occs_queryDb}
\alias{occs_queryDb}
\title{occs_queryDb Query online database for species occurrence records.}
\usage{
occs_queryDb(
  spNames,
  occDb,
  occNum = NULL,
  doCitations = FALSE,
  gbifUser = NULL,
  gbifEmail = NULL,
  gbifPW = NULL,
  RmUncertain = FALSE,
  logger = NULL
)
}
\arguments{
\item{spNames}{character. Species Latin name, with format "Genus species".}

\item{occDb}{character. Biodiversity database to query; current choices are
"gbif", "vertnet", "bison", and "BIEN"}

\item{occNum}{numeric. Maximum number of occurrence records to return}

\item{doCitations}{logical. Set TRUE to use `occCite` to get a complete list
of original data sources in a citable format}

\item{gbifUser}{specify only if using `occCite` with GBIF to get a complete list
of original data sources in a citable format. This, as well as `gbifEmail`
and `gbifPW` are constraints imposed by GBIF to obtain the complete set of
metadata associated with occurrence records and is not stored or used by
`wallace` for any other purposes.}

\item{gbifEmail}{specify only if using `occCite` with GBIF to get a
complete list of original data sources in a citable format.}

\item{gbifPW}{specify only if using `occCite` with GBIF to get a complete
list of original data sources in a citable format.}

\item{RmUncertain}{specify if occurrences without uncertainty information
should be removed (default is FALSE)}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running in shiny,
otherwise leave the default NULL}
}
\value{
list of lists one list per species with occurrence records. Each
  individual species list with appropriate fields for analysis
}
\description{
Queries a given database for occurrence data on the provided species
}
\details{
This function is called by the module occs_queryDb to query a database for
  species occurrence records, subset to only those records with coordinates,
  remove records with duplicate coordinates, and select some columns with fields
  appropriate to studies in biogeography.
}
\examples{
\dontrun{
occs_queryDb(spName = "Bassaricyon alleni", occDb = "gbif", occNum = 10)
}
}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Gonzalo E. Pinilla-Buitrago <gpinillabuitrago@gradcenter.cuny.edu>

Hannah Owens

Andrea Paz <paz.andreita@gmail.com>
}
