% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone_png.R
\name{save_png}
\alias{save_png}
\title{Save a base64-encoded PNG to file}
\usage{
save_png(isochrone_png, file = "isochrone.png")
}
\arguments{
\item{isochrone_png}{a response object from a \link[walkalytics]{isochrone_png} call to the \code{walkalytics} isochrone API.}

\item{file}{character vector, containing file name or path}
}
\description{
\code{save_png} decodes a base64-encoded PNG of a response object from a \link[walkalytics]{isochrone_png} call and
    saves it to file.
}
\examples{
\donttest{
isochrone_png(x = 896488, y = 6006502, key = "abcd1234") \%>\%
    save_png(tempfile(pattern = "file", fileext = ".png"))
}
}
