% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{compare_proxy}
\alias{compare_proxy}
\title{Proxy for waldo comparison}
\usage{
compare_proxy(x, path = "x")
}
\arguments{
\item{x}{An object.}

\item{path}{Path}
}
\value{
A list with two components:
\itemize{
\item \code{object}: the modified object
\item \code{path}: an updated path showing what modification was applied
}
}
\description{
Use this generic to override waldo's default comparison if you need to
override the defaults (typically because your object stores data in an
external pointer).

waldo comes with methods for a few common cases:
\itemize{
\item data.table: the \code{.internal.selfref} attribute is set to \code{NULL}. This is
an external pointer that is used for performance optimisation, and
doesn't affect the data.
\item \code{xml2::xml_node}: the underlying XML data is stored in memory in C,
behind an external pointer, so the we best can do is to convert the
object to a string.
\item Classes from the \code{RProtoBuf} package: like XML objects, these store
data in memory in C++ and only expose string names to R. Fortunately,
these have well-understood string representations that we can use for
comparisons. See
\url{https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.text_format}
}
}
