\name{grid.vwline}
\alias{grid.vwline}
\alias{vwlineGrob}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Draw a variable-width set of line segments.
}
\description{
  Draw a variable-width line where the main line is a series
  of straight line segments and the width is specified at
  each vertex and linearly interpolated along each segment.
}
\usage{
vwlineGrob(x, y, w, default.units="npc", open=TRUE, 
           linejoin="round", lineend="butt", mitrelimit=4,
           stepWidth=FALSE, render=if (open) vwPolygon else vwPath(),
           gp=gpar(fill="black"), name=NULL, debug=FALSE)
grid.vwline(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A numeric vector or unit describing x-locations.}
  \item{y}{A numeric vector or unit describing y-locations.}
  \item{w}{A numeric vector or unit describing widths at each location,
    or a width specification generated by \code{\link{widthSpec}}.}
  \item{default.units}{The units used if \code{x} or \code{y} are
    numeric vectors.}
  \item{open}{A boolean indicating whether to connect the last location
    back to the first location to produce a closed line.}
  \item{linejoin}{The line join style; one of \code{"round"}, \code{"mitre"}, or
    \code{"bevel"}.}
  \item{lineend}{The line ending style; one of \code{"round"},
    \code{"mitre"}, \code{"butt"}, or \code{"square"}.}
  \item{mitrelimit}{A numeric that controls when a mitre join is
    converted to a bevel join or a mitre ending
    is converted to a square ending.}
  \item{stepWidth}{A logical indicating whether widths are fixed along
    the length of a segment.}
  \item{render}{A function that is used to render the outline of the path
    that is generated for the variable-width line.}
  \item{gp}{A set of graphical parameters; see \code{\link{gpar}}.}
  \item{name}{A name for the grob generated for the variable-width
    line.}
  \item{debug}{A logical indicating whether to produce graphical
    debugging output.}
  \item{\dots}{
    Arguments passed to \code{vwlineGrob}.
  }
}
\details{
  If \code{stepWidth} is \code{TRUE}, the last width value is ignored.
}
\value{
  \code{grid.vwline} is used for its side-effect of drawing a
  variable-width
  line;  \code{vwlineGrob} returns a \code{"vwlineGrob"} object.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{grid.vwcurve}},
  \code{\link{grid.vwXspline}},
  \code{\link{grid.brushXspline}},
  \code{\link{grid.offsetXspline}}
}
\examples{
grid.newpage()
grid.vwline(c(.2, .5, .8), rep(.8, 3), unit(c(1, 3, 2), "cm"))
grid.vwline(c(.2, .5, .8), rep(.6, 3), unit(c(1, 3, 2), "cm"),
            stepWidth=TRUE)
grid.vwline(c(.2, .5, .8), rep(.4, 3), unit(c(1, 3, 2), "cm"),
            linejoin="mitre", lineend="round")
grid.vwline(c(.2, .5, .8), rep(.2, 3), unit(c(1, 3, 2), "cm"),
            gp=gpar(col="black"), debug=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ aplot }% use one of  RShowDoc("KEYWORDS")
