% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcn_token.R
\name{tcn_token}
\alias{tcn_token}
\title{Get a twitter API access token}
\usage{
tcn_token(bearer = NULL, consumer_key = NULL, consumer_secret = NULL)
}
\arguments{
\item{bearer}{Character string. App bearer token.}

\item{consumer_key}{Character string. App consumer key.}

\item{consumer_secret}{Character string. App consumer secret.}
}
\value{
Named list containing the token.
}
\description{
Assigns a bearer token to the token object or retrieves a bearer token from the Twitter API using a Twitter apps
consumer keys.
}
\examples{
\dontrun{

# assign bearer token
token <- tcn_token(bearer = "xxxxxxxx")

# retrieve twitter app bearer token
token <- tcn_token(consumer_key = "xxxxxxxx",
                   consumer_secret = "xxxxxxxx")
}

}
