% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_metrics_one}
\alias{plot_metrics_one}
\title{Output a density plot for a single metric variable}
\usage{
plot_metrics_one(
  data,
  col,
  negative = FALSE,
  ci = FALSE,
  box = FALSE,
  limits = NULL,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding metric values.}

\item{negative}{If FALSE (default), negative values are recoded as missing values.}

\item{ci}{Whether to plot the confidence interval.}

\item{box}{Whether to add a boxplot.}

\item{limits}{The scale limits. Set NULL to extract limits from the label.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_metrics}.}
}
\value{
A ggplot object.
}
\description{
Output a density plot for a single metric variable
}
\examples{
library(volker)
data <- volker::chatgpt

plot_metrics_one(data, sd_age)

}
\keyword{internal}
