% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_simplex.R
\name{gen_simplex}
\alias{gen_simplex}
\title{Generator function for simplices}
\usage{
gen_simplex(dimension, representation)
}
\arguments{
\item{dimension}{The dimension of the unit simplex.}

\item{representation}{A string to declare the representation. It has to be \code{'H'} for H-representation or \code{'V'} for V-representation.}
}
\value{
A polytope class representing the \eqn{d}-dimensional unit simplex in H- or V-representation.
}
\description{
This function generates the \eqn{d}-dimensional unit simplex in H- or V-representation.
}
\examples{
# generate a 10-dimensional simplex in H-representation
PolyList = gen_simplex(10, 'H')

# generate a 20-dimensional simplex in V-representation
P = gen_simplex(20, 'V')
}
