% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{tag}
\alias{tag}
\title{Tag a data frame with media information}
\usage{
tag(
  x,
  groupBy = "wav_path",
  wavPath = unique(x$wav_path),
  wavPathName = "wav_path",
  tags = c("feat_summary"),
  sortByGroupBy = TRUE,
  filesRange = NULL,
  features = "f0",
  sex = "u",
  windowShift = 5,
  numFormants = 8,
  numcep = 12,
  dcttype = c("t2", "t1", "t3", "t4"),
  fbtype = c("mel", "htkmel", "fcmel", "bark"),
  resolution = 40,
  usecmp = FALSE,
  mc.cores = 1,
  full.names = TRUE,
  recursive = FALSE,
  check.mono = FALSE,
  stereo2mono = FALSE,
  overwrite = FALSE,
  freq = 44100,
  round.to = 4,
  verbose = FALSE
)
}
\arguments{
\item{x}{An Extended data frame to be tagged with media information. See references.}

\item{groupBy}{A variable to group the summary measures. The argument must be a character vector. (Default: \code{groupBy = 'wav_path'}).}

\item{wavPath}{A vector containing the path(s) to WAV files. May be both as \code{dirname} or \code{basename} formats.}

\item{wavPathName}{A string containing the WAV path name. (Default: \code{wavPathName = 'wav_path'}).}

\item{tags}{Tags to be added to \code{x}. See Details. (Default: \code{'feat_summary'}).}

\item{sortByGroupBy}{Logical. Should the function sort the Extended data frame \code{x} by \code{gropuBy}? (Default: \code{sortByGroupBy = TRUE}).}

\item{filesRange}{The desired range of directory files. Should only be used when all the WAV files are in the same folder. (Default: \code{NULL}, i.e., all files).}

\item{features}{Vector of features to be extracted. (Default: \code{'f0'}).}

\item{sex}{\code{= <code>} set sex specific parameters where <code> = \code{'f'}[emale], \code{'m'}[ale] or \code{'u'}[nknown] (default: \code{'u'}). Used as 'gender' by \code{wrassp::ksvF0}, \code{wrassp::forest} and \code{wrassp::mhsF0}.}

\item{windowShift}{\code{= <dur>} set analysis window shift to <dur>ation in ms (default: 5.0). Used by \code{wrassp::ksvF0}, \code{wrassp::forest}, \code{wrassp::mhsF0}, \code{wrassp::zcrana}, \code{wrassp::rfcana}, \code{wrassp::acfana}, \code{wrassp::cepstrum}, \code{wrassp::dftSpectrum}, \code{wrassp::cssSpectrum} and \code{wrassp::lpsSpectrum}.}

\item{numFormants}{\code{= <num>} <num>ber of formants (Default: \code{8}). Used by \code{wrassp::forest}.}

\item{numcep}{Number of Mel-frequency cepstral coefficients (cepstra) to return (Default: \code{12}). Used by \code{tuneR::melfcc}.}

\item{dcttype}{Type of DCT used. \code{'t1'} or \code{'t2'}, \code{'t3'} for HTK \code{'t4'} for feacalc (Default: \code{'t2'}). Used by \code{tuneR::melfcc}.}

\item{fbtype}{Auditory frequency scale to use: \code{'mel'}, \code{'bark'}, \code{'htkmel'}, \code{'fcmel'} (Default: \code{'mel'}). Used by \code{tuneR::melfcc}.}

\item{resolution}{\code{= <freq>} set FFT length to the smallest value which results in a frequency resolution of <freq> Hz or better (Default: \code{40.0}). Used by \code{wrassp::cssSpectrum}, \code{wrassp::dftSpectrum} and \code{wrassp::lpsSpectrum}.}

\item{usecmp}{Logical. Apply equal-loudness weighting and cube-root compression (PLP instead of LPC) (Default: \code{FALSE}). Used by \code{tuneR::melfcc}.}

\item{mc.cores}{Number of cores to be used in parallel processing. (Default: \code{1})}

\item{full.names}{Logical. If \code{TRUE}, the directory path is prepended to the file names to give a relative file path. If \code{FALSE}, the file names (rather than paths) are returned. (Default: \code{TRUE}) Used by \code{base::list.files}.}

\item{recursive}{Logical. Should the listing recursively into directories? (Default: \code{FALSE}) Used by \code{base::list.files}.}

\item{check.mono}{Logical. Check if the WAV file is mono. (Default: \code{TRUE})}

\item{stereo2mono}{(Experimental) Logical. Should files be converted from stereo to mono? (Default: \code{TRUE})}

\item{overwrite}{(Experimental) Logical. Should converted files be overwritten? If not, the file gets the suffix \code{_mono}. (Default: \code{FALSE})}

\item{freq}{Frequency in Hz to write the converted files when \code{stereo2mono=TRUE}. (Default: \code{44100})}

\item{round.to}{Number of decimal places to round to. (Default: \code{NULL})}

\item{verbose}{Logical. Should the running status be showed? (Default: \code{FALSE})}
}
\value{
A tibble data frame containing summarized numeric columns using (1) mean, (2) standard deviation, (3) variation coefficient, (4) median, (5) interquartile range and (6) median absolute deviation.
}
\description{
Tag a data frame with media information
}
\details{
\code{filesRange} should only be used when all the WAV files are in the same folder.
}
\examples{
library(voice)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern = glob2rx('*.wav'), full.names = TRUE)

# creating Extended synthetic data
E <- dplyr::tibble(subject_id = c(1,1,1,2,2,2,3,3,3),
wav_path = path2wav)
E

# minimal usage
tag(E)

# canonical data
tag(E, groupBy = 'subject_id')

# limiting filesRange
tag(E, filesRange = 3:6)

# more features
Et <- tag(E, features = c('f0', 'fmt', 'rf', 'rcf', 'rpf', 'rfc', 'mfcc'),
groupBy = 'subject_id')
Et
str(Et)
}
