% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_model.R
\name{expand_model}
\alias{expand_model}
\title{Expand model given \code{y} and \code{x} variables.}
\usage{
expand_model(y, x, k)
}
\arguments{
\item{y}{The Y variable.}

\item{x}{The X variables.}

\item{k}{Number of additive components.}
}
\value{
A \code{char} vector containing the expanded models.
}
\description{
Expand model given \code{y} and \code{x} variables.
}
\examples{
library(voice)

expand_model('y', LETTERS[1:4], 1)
expand_model('y', LETTERS[1:4], 2)
expand_model('y', LETTERS[1:4], 3)
expand_model('y', LETTERS[1:4], 4)

# multiple models using apply functions
nx <- 10 # number of X variables to be used
models <- lapply(1:nx, expand_model, y = 'y', x = LETTERS[1:nx])
names(models) <- 1:nx
models
sum(sapply(models, length)) # total of models
}
