% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evppi.R
\name{evppi}
\alias{evppi}
\title{Calculate the expected value of partial perfect information from a decision-analytic model}
\usage{
evppi(
  outputs,
  inputs,
  pars = NULL,
  method = NULL,
  se = FALSE,
  B = 1000,
  nsim = NULL,
  verbose = FALSE,
  check = FALSE,
  ...
)
}
\arguments{
\item{outputs}{This could take one of two forms

"net benefit" form: a matrix or data frame of samples from the uncertainty
distribution of the expected net benefit.  The number of rows should equal
the number of samples, and the number of columns should equal the number
of decision options.

"cost-effectiveness analysis" form: a list with the following named
components:

\code{"c"}: a matrix or data frame of samples from the distribution of
costs.  There should be one column for each decision option.

\code{"e"}: a matrix or data frame of samples from the distribution of
effects, likewise.

\code{"k"}: a vector of willingness-to-pay values.

Objects of class \code{"bcea"}, as created by the \pkg{BCEA} package, are in
this "cost-effectiveness analysis" format, therefore they may be supplied as
the \code{outputs} argument.

Users of \pkg{heemod} can create an object of this form, given an object
produced by \code{run_psa} (\code{obj}, say), with \code{\link{import_heemod_outputs}}.

If \code{outputs} is a matrix or data frame, it is assumed to be of "net
benefit" form.  Otherwise if it is a list, it is assumed to be of "cost
effectiveness analysis" form.}

\item{inputs}{Matrix or data frame of samples from the uncertainty
distribution of the input parameters of the decision model.   The number
of columns should equal the number of parameters, and the columns should
be named.    This should have the same number of rows as there are samples
in \code{outputs}, and each row of the samples in \code{outputs} should
give the model output evaluated at the corresponding parameters.

Users of \pkg{heemod} can create an object of this form, given an object
produced by \code{run_psa} (\code{obj}, say), with \code{\link{import_heemod_inputs}}.}

\item{pars}{Either a character vector, or a list of character vectors.

If a character vector is supplied, then a single, joint EVPPI calculation is done with
for the parameters named in this vector.

If a list of character vectors is supplied,  then multiple EVPPI calculations are
performed, one for each list component defined in the above
vector form.

\code{pars} must be specified if \code{inputs} is a matrix or data frame.
This should then correspond to particular columns of \code{inputs}.    If
\code{inputs} is a vector, this is assumed to define the single parameter
of interest, and then \code{pars} is not required.}

\item{method}{Character string indicating the calculation method.  If one
string is supplied, this is used for all calculations.  A vector of different strings
can be supplied if a different method is desired for different list components
of \code{pars}.

The default methods are based on nonparametric regression:

\code{"gam"} for a generalized additive model implemented in the \code{\link{gam}}
function from the \pkg{mgcv} package.  This is the default method for
calculating the EVPPI of 4 or fewer parameters.

\code{"gp"} for a Gaussian process regression, as described by Strong et al.
(2014) and implemented in the \pkg{SAVI} package
(\url{https://github.com/Sheffield-Accelerated-VoI/SAVI}).  This is the default method for calculating the EVPPI
of more than 4 parameters.

\code{"inla"} for an INLA/SPDE Gaussian process regression method, from
Heath et al. (2016).

\code{"bart"} for Bayesian additive regression trees, using the \pkg{dbarts} package.
Particularly suited for joint EVPPI of many parameters.

\code{"earth"} for a multivariate adaptive regression spline with the
\pkg{earth} package (Milborrow, 2019).

\code{"so"} for the method of Strong and Oakley (2013).  Only supported
for single parameter EVPPI.

\code{"sal"} for the method of Sadatsafavi et al. (2013).  Only supported
for single parameter EVPPI.}

\item{se}{If this is \code{TRUE}, calculate a standard error for the EVPPI
if possible.  Currently only supported for methods \code{"gam"}, \code{"earth"} and
\code{method="bart"}.  (In the latter method it is more correctly called
a posterior standard deviation).  These represent uncertainty about the
parameters of the fitted regression model, and will naturally be lower when
more simulations from the decision model are used to fit it.  They do not
represent uncertainty about the structure of the regression model,}

\item{B}{Number of parameter replicates for calculating the standard error.
Only applicable to \code{method="gam"}.  For \code{method="bart"} the
analogous quantity is the number of MCMC samples, which is controlled by
the \code{ndpost} argument to \code{\link[dbarts]{bart}}, which can be
passed as an argument to \code{\link{evppi}}.}

\item{nsim}{Number of simulations from the decision model to use
for calculating EVPPI.  The first \code{nsim} rows of the
objects in \code{inputs} and \code{outputs} are used.}

\item{verbose}{If \code{TRUE}, then messages are printed
describing each step of the calculation, if the method supplies
these.  Can be useful to see the progress of slow calculations.}

\item{check}{If \code{TRUE}, then extra information about the estimation
is saved inside the object that this function returns.  This currently
only applies to the regression-based methods \code{"gam"} and \code{"earth"}
where the fitted regression model objects are saved.  This allows use
of the \code{\link{check_regression}} function, which produces some
diagnostic checks of the regression models.}

\item{...}{Other arguments to control specific methods.

For \code{method="gam"}, the following arguments can be supplied:
\itemize{
\item \code{gam_formula}: a character string giving the right hand side of the
formula supplied to the \code{gam()} function. By default, this is a tensor
product of all the parameters of interest, e.g. if \code{pars =
c("pi","rho")}, then \code{gam_formula} defaults to \code{t(pi, rho,
bs="cr")}.  The option \code{bs="cr"} indicates a cubic spline regression
basis, which is more computationally efficient than the default "thin plate"
basis.  If there are four or more parameters of interest, then the
additional argument \code{k=4} is supplied to \code{te()}, specifying a
four-dimensional basis, which is currently the default in the SAVI package.

If there are spaces in the variable names in \code{inputs}, then these should
be converted to underscores before forming an explicit \code{gam_formula}.
}

For \code{method="gp"}, the following arguments can be supplied:
\itemize{
\item \code{gp_hyper_n}: number of samples to use to estimate the hyperparameters
in the Gaussian process regression method.  By default, this is the minimum
of the following three quantities: 30 times the number of parameters of
interest, 250, and the number of simulations being used for calculating
EVPPI.
\item \code{maxSample}: Maximum sample size to employ for \code{method="gp"}.  Only
increase this from the default 5000 if your computer has sufficent memory to
invert square matrices with this dimension.
}

For \code{method="inla"}, the following arguments can be supplied, as described in detail in Baio, Berardi and Heath (2017):
\itemize{
\item \code{int.ord} (integer) maximum order of interaction terms to include in
the regression predictor, e.g. if \code{int.ord=k} then all k-way
interactions are used.  Currently this applies to both effects and costs.
\item \code{cutoff} (default 0.3) controls the
density of the points inside the mesh in the spatial part of the mode.
Acceptable values are typically in
the interval (0.1,0.5), with lower values implying more points (and thus
better approximation and greatercomputational time).
\item \code{convex.inner} (default = -0.4) and \code{convex.outer} (default = -0.7)
control the boundaries for the mesh. These should be negative values and can
be decreased (say to -0.7 and -1, respectively) to increase the distance
between the points and the outer boundary, which also increases precision and
computational time.
\item \code{robust}. if \code{TRUE} then INLA will use a t prior distribution for
the coefficients of the linear predictor, rather than the default normal distribution.
\item \code{h.value} (default=0.00005) controls the accuracy of the INLA
grid-search for the estimation of the hyperparameters. Lower values imply a
more refined search (and hence better accuracy), at the expense of
computational speed.
\item \code{plot_inla_mesh} (default \code{FALSE}) Produce a plot of the mesh.
\item \code{max.edge}  Largest allowed triangle edge length when constructing the
mesh, passed to \code{\link[INLA]{inla.mesh.2d}}.
\item \code{pfc_struc} Variance structure to pass to \code{pfc} in the \pkg{ldr}
package for principal fitted components. The default \code{"AIC"} selects the
one that fits best given two basis terms.  Change this to, e.g. \code{"iso"},
\code{"aniso"} or \code{"unstr"} if an "Error in eigen..." is obtained.
}

For \code{method="so"}:
\itemize{
\item \code{n.blocks} Number of blocks to split the sample into. Required.
}

For \code{method="sal"}:
\itemize{
\item \code{n.seps} Number of separators (default 1).
}}
}
\value{
A data frame with a column \code{pars}, indicating the parameter(s),
and a column \code{evppi}, giving the corresponding EVPPI.

If \code{outputs} is of "cost-effectiveness analysis" form, so that there is
one EVPPI per willingness-to-pay value, then a column \code{k} identifies the
willingness-to-pay.

If standard errors are requested, then the standard errors are returned in
the column \code{se}.
}
\description{
Calculate the expected value of partial perfect information from a decision-analytic model
}
\references{
Strong, M., Oakley, J. E., & Brennan, A. (2014). Estimating multiparameter
partial expected value of perfect information from a probabilistic
sensitivity analysis sample: a nonparametric regression approach. Medical
Decision Making, 34(3), 311-326.

Heath, A., Manolopoulou, I., & Baio, G. (2016). Estimating the expected
value of partial perfect information in health economic evaluations using
integrated nested Laplace approximation. Statistics in Medicine, 35(23),
4264-4280.

Baio, G., Berardi, A., & Heath, A. (2017). Bayesian cost-effectiveness
analysis with the R package BCEA. New York: Springer.

Milborrow, S. (2019) earth: Multivariate Adaptive Regression Splines. R
package version 5.1.2. Derived from mda:mars by Trevor Hastie and Rob
Tibshirani. Uses Alan Miller's Fortran utilities with Thomas Lumley's leaps
wrapper. https://CRAN.R-project.org/package=earth.

Strong, M., & Oakley, J. E. (2013). An efficient method for computing
single-parameter partial expected value of perfect information. Medical
Decision Making, 33(6), 755-766. Chicago

Sadatsafavi, M., Bansback, N., Zafari, Z., Najafzadeh, M., & Marra, C.
(2013). Need for speed: an efficient algorithm for calculation of
single-parameter expected value of partial perfect information. Value in
Health, 16(2), 438-448.
}
