% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDM.R, R/LC.R, R/fmean.R, R/fnaive.R,
%   R/forecast.R
\name{forecast.FDM}
\alias{forecast.FDM}
\alias{forecast.LC}
\alias{forecast.FMEAN}
\alias{forecast.FNAIVE}
\alias{forecast.mdl_vtl_df}
\title{Produce forecasts from a vital model}
\usage{
\method{forecast}{FDM}(
  object,
  new_data = NULL,
  h = NULL,
  point_forecast = list(.mean = mean),
  simulate = FALSE,
  bootstrap = FALSE,
  times = 5000,
  ...
)

\method{forecast}{LC}(
  object,
  new_data = NULL,
  h = NULL,
  point_forecast = list(.mean = mean),
  simulate = FALSE,
  bootstrap = FALSE,
  times = 5000,
  ...
)

\method{forecast}{FMEAN}(
  object,
  new_data = NULL,
  h = NULL,
  point_forecast = list(.mean = mean),
  simulate = FALSE,
  bootstrap = FALSE,
  times = 5000,
  ...
)

\method{forecast}{FNAIVE}(
  object,
  new_data = NULL,
  h = NULL,
  point_forecast = list(.mean = mean),
  simulate = FALSE,
  bootstrap = FALSE,
  times = 5000,
  ...
)

\method{forecast}{mdl_vtl_df}(
  object,
  new_data = NULL,
  h = NULL,
  point_forecast = list(.mean = mean),
  simulate = FALSE,
  bootstrap = FALSE,
  times = 5000,
  ...
)
}
\arguments{
\item{object}{A mable containing one or more models.}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{h}{Number of time steps ahead to forecast. This can be used instead of \code{new_data}
when there are no covariates in the model. It is ignored if \code{new_data} is provided.}

\item{point_forecast}{A list of functions used to compute point forecasts from the forecast distribution.}

\item{simulate}{If  \code{TRUE}, then forecast distributions are computed using simulation from a parametric model.}

\item{bootstrap}{If \code{TRUE}, then forecast distributions are computed using simulation with resampling.}

\item{times}{The number of sample paths to use in estimating the forecast distribution when \code{bootstrap = TRUE}.}

\item{...}{Additional arguments passed to the specific model method.}
}
\value{
A fable containing the following columns:
\itemize{
\item \code{.model}: The name of the model used to obtain the forecast. Taken from
the column names of models in the provided mable.
\item The forecast distribution. The name of this column will be the same as the
dependent variable in the model(s). If multiple dependent variables exist,
it will be named \code{.distribution}.
\item Point forecasts computed from the distribution using the functions in the
\code{point_forecast} argument.
\item All columns in \code{new_data}, excluding those whose names conflict with the
above.
}
}
\description{
The forecast function allows you to produce future predictions of a vital
model, where the response is a function of age.
The forecasts returned contain both point forecasts and their distribution.
}
\examples{
aus_mortality |>
 dplyr::filter(State == "Victoria", Sex == "female") |>
 model(naive = FNAIVE(Mortality)) |>
 forecast(h = 10)

}
\author{
Rob J Hyndman and Mitchell O'Hara-Wild
}
