% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.mdl_vtl_df}
\alias{autoplot.mdl_vtl_df}
\title{Plot output from a vital model}
\usage{
\method{autoplot}{mdl_vtl_df}(object, ...)
}
\arguments{
\item{object}{A mable object obtained from a vital.}

\item{...}{Further arguments ignored.}
}
\value{
A ggplot2 object.
}
\description{
Produces a plot showing a model applied to a vital object. This can be applied
to one type of model only. So use select() to choose the model column to plot.
If there are multiple keys, separate models will be identified by colour.
}
\examples{
library(ggplot2)
aus_mortality |>
 dplyr::filter(State == "Victoria") |>
 model(ave = FMEAN(Mortality)) |>
 autoplot() + scale_y_log10()

}
\author{
Rob J Hyndman
}
