% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfreports.R
\name{vfspa}
\alias{vfspa}
\alias{vfspashiny}
\title{Series Progession Analysis}
\usage{
vfspa(
  vf,
  file,
  type = "td",
  nperm = factorial(7),
  trunc = 1,
  testSlope = 0,
  ...
)

vfspashiny(
  vf,
  type = "td",
  nperm = factorial(7),
  trunc = 1,
  testSlope = 0,
  ...
)
}
\arguments{
\item{vf}{visual field data}

\item{file}{The pdf file name where to save the one-page reports of single field analysis}

\item{type}{Type of data to use. It can be `\code{s}`, `\code{td}`, or
`\code{pd}`.}

\item{nperm}{Number of permutations. Default is 7!}

\item{trunc}{value for the Truncated Product Method (see reference).
Default is 1}

\item{testSlope}{slope, or slopes, to test as null hypothesis. Default is 0.
if a single value, then the same null hypothesis is used for all locations.
If a vector of values, then (for \code{plr} and \code{poplr}) each
location of the visual field will have a different null hypothesis. The length
of testSlope must be 1 or equal to the number of locations to be used in the PLR
or PoPLR analysis}

\item{...}{other graphical arguments}
}
\value{
No return value
}
\description{
Generation of one-page reports of series progression analyses
\itemize{
  \item\code{vfspa} saves a pdf with one-page reports of series progression analyses
  \item\code{vfspashiny} generates interactive one-page reports of series progression
    analyses based on Shiny
}
}
\references{
N. O'Leary, B. C. Chauhan, and P. H. Artes. \emph{Visual field progression in
glaucoma: estimating the overall significance of deterioration with permutation
analyses of pointwise linear regression (PoPLR)}. Investigative Ophthalmology
and Visual Science, 53, 2012

N. O'Leary, B. C. Chauhan, and P. H. Artes. \emph{Visual field progression in
glaucoma: estimating the overall significance of deterioration with permutation
analyses of pointwise linear regression (PoPLR)}. Investigative Ophthalmology
and Visual Science, 53, 2012
}
