% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_analysis.R
\name{vtTrack}
\alias{vtTrack}
\title{Plot the track plot of dose escalation}
\usage{
vtTrack(obs.all, cex.txt = 0.9, decision = 1, max.level = NULL,
  letters = c("E", "C", "S"), colors = c("green", "yellow", "red"),
  height = 0.5, end.width = 2, end.height = height,
  cex.roman = 0.9, cex.end = 0.9, ...)
}
\arguments{
\item{obs.all}{All observations collected in a matrix with 5 columns. Column
1 is the index of interim analysis starting from 1. Columns 2-5
correspond to columns 1-4 in \code{obs.y} for \code{\link{vtPost}}.}

\item{cex.txt}{Text size of numbers in the plot}

\item{decision}{Dose escalation decision. The options are
\itemize{
\item{\code{1}: }{Escalate}
\item{\code{2}: }{Continue at the same level}
\item{\code{3}: }{Stop the trial}
}}

\item{max.level}{Maximum number of dose levels shown in the plot}

\item{letters}{Labels for dose escalation actions 1-3. Default values are
"E", "C", "S"}

\item{colors}{Possible colors in the last action box}

\item{height}{Height of each individual box}

\item{end.width}{Width of the last action box}

\item{end.height}{Height of the last action box}

\item{cex.roman}{Text size of the roman numerals}

\item{cex.end}{Text size of the letter in the last action box}

\item{...}{Optional arguments for \code{plot}.}
}
\description{
Generate a plot representing the observed data and dose escalation decisions.
}
\examples{

obs.all  <- rbind(c(1, 5, 2, 0, 0),
                  c(2, 3, 4, 0, 0),
                  c(3, 1, 6, 0, 0));
vtTrack(obs.all, end.width = 0.8, max.level = 3, decision = 3);

}
