% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvial_diagram.R
\name{alluvial_diagram}
\alias{alluvial_diagram}
\title{alluvial_diagram}
\usage{
alluvial_diagram(
  linkData,
  nodeData = NULL,
  sourceAccessor,
  targetAccessor,
  valueAccessor,
  nodeIDAccessor = "",
  groupAccessor = "",
  mainTitle = "",
  subTitle = "",
  accessibility = list(),
  props = list(),
  ...
)
}
\arguments{
\item{linkData}{required to be a valid, R data frame. Data used to create links in diagram, an array of objects which includes keys that map to chart accessors. See \href{https://github.com/d3/d3-sankey}{d3-sankey} for additional detail on data requirements.}

\item{nodeData}{required to be a valid, R data frame. Optional. Data used to create nodes in diagram, an array of objects which includes key that map to chart accessors. See \href{https://github.com/d3/d3-sankey}{d3-sankey} for additional detail on data requirements.}

\item{sourceAccessor}{String. Key used to determine link's source, must be a node.}

\item{targetAccessor}{String. Key used to determine link's target, must be a node.}

\item{valueAccessor}{String. Key used to determine link (and ultimately node size).}

\item{nodeIDAccessor}{String. Key used to determine unique node identifiers. Requires nodeData to be populated.}

\item{groupAccessor}{String. Key used to determine link's group or category.}

\item{mainTitle}{String. The dynamic tag of title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{subTitle}{String. The dynamic tag for a sub title for the map (or you can create your own separately). See \code{highestHeadingLevel} prop for how tags get assigned.}

\item{accessibility}{List(). Manages messages and settings for chart accessibility, see \href{https://github.com/visa/visa-chart-components/tree/master/packages/alluvial-diagram#accessibility-props}{object definition}}

\item{props}{List(). A valid R list with additional property configurations, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/alluvial-diagram}{@visa/alluvial-diagram}}

\item{...}{All other props passed into the function will be passed through to the chart, see all props for \href{https://github.com/visa/visa-chart-components/tree/master/packages/alluvial-diagram}{@visa/alluvial-diagram}.}
}
\value{
a visaNodeLinkChart htmlwidget object for plotting an alluvial diagram
}
\description{
R wrapper for \href{https://github.com/visa/visa-chart-components/tree/master/packages/alluvial-diagram}{@visa/alluvial-diagram} via \href{https://www.htmlwidgets.org/}{htmlwidgets}.

Here is an example of alluvial-diagram in action:
\if{html}{\figure{alluvial-diagram-1.png}{options: width=400 alt="example alluvial diagram"}}
}
\details{
To see all available options for the chart properties/API see \href{https://github.com/visa/visa-chart-components/tree/master/packages/alluvial-diagram}{@visa/alluvial-diagram}.
}
\examples{
library(tidyverse)
data.frame(HairEyeColor) \%>\%
  filter(Sex=="Female") \%>\%
  mutate(newHair = paste(Hair,"-Hair")) \%>\%
  mutate(newEye = paste(Eye,"-Eye")) \%>\%
  alluvial_diagram(sourceAccessor = "newHair", targetAccessor = "newEye", valueAccessor = "Freq")
}
