% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visClustering.R
\name{visClusteringByHubsize}
\alias{visClusteringByHubsize}
\title{Network visualization clustering options - by hubsize}
\usage{
visClusteringByHubsize(graph, size = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{size}{: Integer. This method checks all nodes in the network and those with a equal or higher amount of edges than specified with size argument. If size is null (defaut), the size will be determined as the average value plus two standard deviations.}
}
\description{
Network visualization clustering options - by hubsize
}
\examples{

set.seed(124)
nodes <- data.frame(id = 1:10, color = c(rep("blue", 6), rep("red", 3), rep("green", 1)))
edges <- data.frame(from = round(runif(6)*10), to = round(runif(6)*10))

visNetwork(nodes, edges) \%>\%
 visClusteringByHubsize()
 
visNetwork(nodes, edges) \%>\%
 visClusteringByHubsize(size = 2)
 
}
