% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visNetworkProxy.R
\name{visNetworkProxy}
\alias{visNetworkProxy}
\title{Send methods to a visNetwork instance in a Shiny app}
\usage{
visNetworkProxy(shinyId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{shinyId}{single-element character vector indicating the shiny output ID of the
network to modify}

\item{session}{the Shiny session object to which the map belongs; usually the
  default value will suffice}
}
\description{
Creates a visNetwork object that can be used to customize and control after rendering.
For use in Shiny apps and Shiny docs only.
}
\details{
With \code{visNetworkProxy}, you can use various methods like
\code{\link{visOptions}}, \code{\link{visNodes}}, \code{\link{visEdges}},
\code{\link{visPhysics}}, ... and more with special call for \code{visNetworkProxy} object like
\code{\link{visFocus}}, \code{\link{visFit}}, \code{\link{visRedraw}}.
}
\examples{
\dontrun{

# have a look to :
shiny::runApp(system.file("shiny", package = "visNetwork"))

}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options,
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout,
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

