% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_comments.R
\name{add_comments}
\alias{add_comments}
\title{Add comments on Files and URLs}
\usage{
add_comments(hash = NULL, comment = NULL, ...)
}
\arguments{
\item{hash}{hash for the resource you want to comment on; Required; String}

\item{comment}{review; Required; String}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}.}
}
\value{
data.frame with 2 columns: \code{response_code}, \code{verbose_msg} 
\itemize{
\item If the hash is incorrect or a duplicate comment is posted, \code{response_code} will be \code{0} 
\item If the hash is incorrect, \code{verbose_msg} will be \code{'Invalid resource'} 
\item If a duplicate comment is posted, \code{verbose_msg} will be \code{'Duplicate comment'} 
\item If a comment is posted successfully, \code{response_code} will be \code{1} 
and \code{verbose_msg} will be \code{'Your comment was successfully posted'} 
}
}
\description{
Add comments on files and URLs. For instance, flagging false positives, adding details about malware, instructions for cleaning malware, etc.
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')
  
add_comments(hash='99017f6eebbac24f351415dd410d522d', comment="This is great.")


}
}
\references{
\url{https://www.virustotal.com/en/documentation/public-api/}
}
\seealso{
\code{\link{set_key}} for setting the API key
}

