% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_domain_score.R
\name{rf_domain_score}
\alias{rf_domain_score}
\title{Calculate the Random Forest Model Domain Applicability Score}
\usage{
rf_domain_score(
  featured_col,
  train_data,
  rf_hyperparameters,
  test_data,
  threshold_value
)
}
\arguments{
\item{featured_col}{A character string specifying the name of the response variable to predict.}

\item{train_data}{A data frame containing predictor variables and the response variable for training the model.}

\item{rf_hyperparameters}{A list of hyperparameters for the Random Forest model, including:
\itemize{
\item \code{mtry}: Number of predictors sampled at each split.
\item \code{min_n}: Minimum number of data points in a node for further splitting.
\item \code{trees}: Number of trees in the ensemble.
}}

\item{test_data}{A data frame for making predictions.}

\item{threshold_value}{A numeric threshold value used for computing domain applicability scores.}
}
\value{
A data frame containing the computed domain applicability scores for each observation in the test dataset.
}
\description{
This function fits a Random Forest model to the provided data and computes a domain applicability score based on PCA distances.
}
\details{
Random Forest creates a large number of decision trees, each independent of the others. The final prediction combines the predictions from all individual trees. This function uses the \code{ranger} engine for fitting regression models.
}
\examples{
set.seed(123)
library(dplyr)
featured_col <- "cd_2022"
train_data <- viral \%>\%
  dplyr::select(cd_2022, vl_2022)
test_data <- sero
rf_hyperparameters <- list(mtry = 2, min_n = 5, trees = 500)
threshold_value <- 0.99
rf_domain_score(featured_col, train_data, rf_hyperparameters, test_data, threshold_value)
}
