% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_or_mod.R
\name{compute_or_mod}
\alias{compute_or_mod}
\title{Compute (r)OR from a model summary}
\usage{
compute_or_mod(.coef_table, estimate, std_er, p_val = NULL, alpha = 0.05)
}
\arguments{
\item{.coef_table}{A coefficient table, see details.}

\item{estimate}{Quasiquoted name of estimate parameter.}

\item{std_er}{Quasiquoted name of standard error parameter.}

\item{p_val}{Quasiquoted name of p-value parameter. Optional.}

\item{alpha}{alpha risk.}
}
\value{
A data.table with OR, confidence intervals (at \code{1 - alpha}),
significance (\code{low_ci > 1}) and (optionally) p-value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Compute and format Odds-Ratio
from a model summary.
}
\details{
Helper to compute and format Odds-Ratio based on
\code{summary(glm)$coefficients}, or any equivalent in other modelling packages.
(see examples).
Preferably, it is transformed into a data.table or data.frame before being
evaluated in the function. Otherwise, \code{compute_or_mod()} will transform it.
Significant OR-or column means low_ci is > 1.
The \code{p_val} argument is only required if you wished to display a \code{\link[=nice_p]{nice_p()}}.

Output is a data.table.
Actually, the function computes an Odds-Ratio, which is not necessarily a \emph{reporting} Odds-Ratio.
}
\examples{

# Reporting Odds-Ratio of colitis with nivolumab among ICI cases.

demo <-
  demo_ |>
  add_drug(
    d_code = ex_$d_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )

# Compute the model
mod <- glm(a_colitis ~ nivolumab, data = demo, family = "binomial")

# Extract coefficients
mod_summary <-
 mod |>
 summary()

coef_table <-
 mod_summary$coefficients

# Transform coefficients into ORs with their CI

coef_table |>
  compute_or_mod(
  estimate = Estimate,
  std_er = Std..Error,
  p_val = Pr...z..)

# Also works if you don't have a p_val column
 coef_table |>
  compute_or_mod(
  estimate = Estimate,
  std_er = Std..Error)
}
\seealso{
\code{\link[=compute_dispro]{compute_dispro()}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}
}
\keyword{disproportionality}
