% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_replicates.R
\name{proportions_imputed}
\alias{proportions_imputed}
\title{Calculate the proportions of each level of a variable after
applying \code{combine_replicates} to completed data (includes imputed values).}
\usage{
proportions_imputed(complete_data, strata_vars, digits = 2)
}
\arguments{
\item{complete_data}{A data frame containing the output from \code{combine_replicates}.}

\item{strata_vars}{A vector of column names identifying the variables to be
used for stratification.}

\item{digits}{Number of decimal places to round the results to. Default value
is 2.}
}
\value{
A data frame that contains the proportions after applying
\code{combine_replicates}.
}
\description{
Calculate the proportions of each level of a variable after
applying \code{combine_replicates} to completed data (includes imputed values).
}
\examples{
local_dir <- system.file("extdata", "right", package = "verdata")
replicates_data <- read_replicates(replicates_dir = local_dir,
violation = "reclutamiento", replicate_nums = c(1, 2), version = "v1",
crash = TRUE)
replicates_obs_data <- summary_observed("reclutamiento", replicates_data,
strata_vars = "sexo", conflict_filter = FALSE, forced_dis_filter = FALSE,
edad_minors_filter = FALSE, include_props = FALSE)
tab_combine <- combine_replicates("reclutamiento", replicates_obs_data,
replicates_data, strata_vars = 'sexo', conflict_filter = TRUE,
forced_dis_filter = FALSE, edad_minors_filter = FALSE, include_props = FALSE)
prop_data_complete <- proportions_imputed(tab_combine, strata_vars = "sexo",
digits = 2)
}
