% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vegaspec.R
\name{as_vegaspec}
\alias{as_vegaspec}
\alias{as_vegaspec.default}
\alias{as_vegaspec.vegaspec}
\alias{as_vegaspec.list}
\alias{as_vegaspec.json}
\alias{as_vegaspec.character}
\alias{as_vegaspec.vegawidget}
\title{Coerce to vegaspec}
\usage{
as_vegaspec(spec, ...)

\method{as_vegaspec}{default}(spec, ...)

\method{as_vegaspec}{vegaspec}(spec, ...)

\method{as_vegaspec}{list}(spec, ...)

\method{as_vegaspec}{json}(spec, ...)

\method{as_vegaspec}{character}(spec, encoding = "UTF-8", ...)

\method{as_vegaspec}{vegawidget}(spec, ...)
}
\arguments{
\item{spec}{An object to be coerced to \code{vegaspec}, a Vega/Vega-Lite specification}

\item{...}{Other arguments (attempt to future-proof)}

\item{encoding}{\code{character}, if spec is a file or a URL, specifies the encoding.}
}
\value{
An object with S3 class \code{vegaspec}
}
\description{
Vega and Vega-Lite use JSON as their specification-format. Within R,
it seems natural to work with these specifications as lists. Accordingly,
a \code{vegaspec} is also a list. This family of functions is used to coerce lists,
JSON, and character strings to \code{vegaspec}.
}
\details{
The \code{character} method for this function will take:
\itemize{
\item{JSON string.}
\item{A path to a local JSON file.}
\item{A URL that returns a JSON file.}
}

For Vega and Vega-Lite, the translation between lists and JSON is a little
bit particular. This function, \code{\link[=as_vegaspec]{as_vegaspec()}}, can be used to translate
from JSON; \code{\link[=vw_as_json]{vw_as_json()}} can be used to translate to JSON.

You can use the function \code{\link[=vw_spec_version]{vw_spec_version()}} to determine if a \code{vegaspec} is built for
Vega-Lite or Vega. You can use \code{\link[=vw_to_vega]{vw_to_vega()}} to translate a Vega-Lite spec to Vega.
}
\examples{
  spec <- list(
    `$schema` = vega_schema(),
    data = list(values = mtcars),
    mark = "point",
    encoding = list(
      x = list(field = "wt", type = "quantitative"),
      y = list(field = "mpg", type = "quantitative"),
      color = list(field = "cyl", type = "nominal")
    )
  )

  as_vegaspec(spec)

  \dontrun{
    # requires network-access
    as_vegaspec("https://vega.github.io/vega-lite/examples/specs/bar.vl.json")
  }
}
\seealso{
\href{https://vega.github.io/vega/}{Vega},
\href{https://vega.github.io/vega-lite/}{Vega-Lite},
\code{\link[=vw_as_json]{vw_as_json()}}, \code{\link[=vw_spec_version]{vw_spec_version()}}, \code{\link[=vw_to_vega]{vw_to_vega()}}
}
