% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{vec-recode-and-replace}
\alias{vec-recode-and-replace}
\alias{vec_recode_values}
\alias{vec_replace_values}
\title{Recode and replace values}
\usage{
vec_recode_values(
  x,
  ...,
  from,
  to,
  default = NULL,
  unmatched = "default",
  from_as_list_of_vectors = FALSE,
  to_as_list_of_vectors = FALSE,
  ptype = NULL,
  x_arg = "x",
  from_arg = "from",
  to_arg = "to",
  default_arg = "default",
  error_call = current_env()
)

vec_replace_values(
  x,
  ...,
  from,
  to,
  from_as_list_of_vectors = FALSE,
  to_as_list_of_vectors = FALSE,
  x_arg = "x",
  from_arg = "from",
  to_arg = "to",
  error_call = current_env()
)
}
\arguments{
\item{x}{A vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{from}{Values to locate in \code{x} and map to values in \code{to}.

Extra values present in \code{from} but not in \code{x} are ignored.
\itemize{
\item If \code{from_as_list_of_vectors = FALSE}, \code{from} must be a single vector of
any size, which will be \link[=theory-faq-coercion]{cast} to the type of
\code{x}.
\item If \code{from_as_list_of_vectors = TRUE}, \code{from} must be a list of vectors of
any size, which will individually be \link[=theory-faq-coercion]{cast}
to the type of \code{x}.
}}

\item{to}{Values to map \code{from} to.

The common type of \code{to} and \code{default} will determine the type of the
output, unless \code{ptype} is provided.
\itemize{
\item If \code{to_as_list_of_vectors = FALSE}, \code{to} must be a single vector of size
1 or the same size as \code{from}.
\item If \code{to_as_list_of_vectors = TRUE}, \code{to} must be a list of vectors. The
list itself must be size 1 or the same size as \code{from}. Each individual
vector in the list must be size 1 or the same size as \code{x}.
}}

\item{default}{Default value to use when there is a value present in \code{x}
that is unmatched by a value in \code{from}.

By default, a missing value is used as the default value.

If supplied, \code{default} must be size 1 or the same size as \code{x}.

Can only be set when \code{unmatched = "default"}.}

\item{unmatched}{Handling of unmatched locations.

One of:
\itemize{
\item \code{"default"} to use \code{default} in unmatched locations.
\item \code{"error"} to error when there are unmatched locations.
}}

\item{from_as_list_of_vectors, to_as_list_of_vectors}{Boolean values
determining whether to treat \code{from} and \code{to} as vectors or as lists of
vectors. See their parameter descriptions for more details.}

\item{ptype}{An optional override for the output type, which is usually
computed as the common type of \code{to} and \code{default}.}

\item{x_arg, from_arg, to_arg, default_arg}{Argument names used in error
messages.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A vector the same size as \code{x}.
\itemize{
\item For \code{vec_recode_values()}, the type of the output is computed as the common
type of \code{to} and \code{default}, unless overridden by \code{ptype}. The names of the
output come from the names of \code{to} and \code{default}.
\item For \code{vec_replace_values()}, the type of the output will have the same type
as \code{x}. The names of the output will be the same as the names of \code{x}.
}
}
\description{
\itemize{
\item \code{vec_recode_values()} constructs an entirely new vector by recoding the
values from \code{x} specified in \code{from} to the corresponding values in \code{to}. If
there are values in \code{x} not matched by \code{from}, then they are recoded to the
\code{default} value.
\item \code{vec_replace_values()} updates an existing vector by replacing the values
from \code{x} specified in \code{from} with the corresponding values in \code{to}. In this
case, \code{to} must have the same type as \code{x} and values in \code{x} not matched by
\code{from} pass through untouched.
}
}
\examples{
x <- c(1, 2, 3, 1, 2, 4, NA, 5)

# Imagine you have a pre-existing lookup table
likert <- data.frame(
  from = c(1, 2, 3, 4, 5),
  to = c(
    "Strongly disagree",
    "Disagree",
    "Neutral",
    "Agree",
    "Strongly agree"
  )
)
vec_recode_values(x, from = likert$from, to = likert$to)

# If you don't map all of the values, a `default` is used
x <- c(1, 2, 3, 1, 2, 4, NA, 5, 6, 7)
vec_recode_values(x, from = likert$from, to = likert$to)
vec_recode_values(x, from = likert$from, to = likert$to, default = "Unknown")

# If you want existing `NA`s to pass through, include a mapping for `NA` in
# your lookup table
likert <- data.frame(
  from = c(1, 2, 3, 4, 5, NA),
  to = c(
    "Strongly disagree",
    "Disagree",
    "Neutral",
    "Agree",
    "Strongly agree",
    NA
  )
)
vec_recode_values(x, from = likert$from, to = likert$to, default = "Unknown")

# If you believe you've captured all of the cases, you can assert this with
# `unmatched = "error"`, which will error if you've missed any cases
# (including `NA`, which must be explicitly handled)
try(vec_recode_values(
  x,
  from = likert$from,
  to = likert$to,
  unmatched = "error"
))

if (require("tibble")) {
  # If you want to partially update `x`, retaining the type of `x` and
  # leaving values not covered by `from` alone, use `vec_replace_values()`
  universities <- c(
    "Duke",
    "Fake U",
    "Duke U",
    NA,
    "Chapel Hill",
    "UNC",
    NA,
    "Duke"
  )

  standardize <- tibble::tribble(
    ~from, ~to,
    "Duke", "Duke University",
    "Duke U", "Duke University",
    "UNC", "UNC Chapel Hill",
    "Chapel Hill", "UNC Chapel Hill",
  )
  vec_replace_values(
    universities,
    from = standardize$from,
    to = standardize$to
  )

  # In this case, you can use a more powerful feature of
  # `vec_replace_values()`, `from_as_list_of_vectors`, which allows you to
  # provide a list of `from` vectors that each match multiple `from` values
  # to a single `to` value. `tribble()` can help you create these!
  standardize <- tibble::tribble(
    ~from, ~to,
    c("Duke", "Duke U"), "Duke University",
    c("UNC", "Chapel Hill"), "UNC Chapel Hill",
  )

  # Note how `from` is a list column
  standardize

  vec_replace_values(
    universities,
    from = standardize$from,
    to = standardize$to,
    from_as_list_of_vectors = TRUE
  )

  # `vec_replace_values()` is also a useful way to map from or to `NA`
  vec_replace_values(universities, from = NA, to = "Unknown")
  vec_replace_values(universities, from = "Fake U", to = NA)
}
}
