% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_treemap}
\alias{v_treemap}
\title{Create a Treemap Chart}
\usage{
v_treemap(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  drill = TRUE,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{drill}{Drill-down function switch.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Treemap Chart
}
\examples{

library(vchartr)

# Basic Treemap Chart
vchart(countries_gdp) \%>\%
  v_treemap(aes(lvl1 = REGION_UN, lvl2 = ADMIN, value = GDP_MD))

# With labels
vchart(countries_gdp) \%>\%
  v_treemap(
    aes(lvl1 = REGION_UN, lvl2 = ADMIN, value = GDP_MD),
    label = list(visible = TRUE)
  )

# Show all levels
vchart(countries_gdp) \%>\%
  v_treemap(
    aes(lvl1 = REGION_UN, lvl2 = ADMIN, value = GDP_MD),
    label = list(visible = TRUE),
    nonLeaf = list(visible = TRUE),
    nonLeafLabel = list(visible = TRUE, position = "top")
  )
}
