% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf-summary.R
\name{vcfsummary}
\alias{vcfsummary}
\title{summarize the various variant types at both variant level and sample level.}
\usage{
vcfsummary(
  vcffile,
  region = "",
  samples = "-",
  pass = FALSE,
  qual = 0,
  svtype = FALSE
)
}
\arguments{
\item{vcffile}{path to the VCF/BCF file}

\item{region}{region to subset like bcftools}

\item{samples}{samples to subset like bcftools}

\item{pass}{restrict to variants with FILTER==PASS}

\item{qual}{restrict to variants with QUAL > qual.}

\item{svtype}{summarize the variants with SVTYPE}
}
\value{
\code{vcfsummary} a list containing the following components:
\describe{
\item{summary}{: named integer vector; \cr
summarize the counts of each variant type
}

\item{samples}{: character vector; \cr
the samples ids in the VCF file after subsetting
}

\item{vartype}{: integer vector; \cr
the counts of the variant type at sample level in the same order as \code{samples}
}

}
}
\description{
summarize the various variant types at both variant level and sample level.
}
\details{
bcftools view -s "id01,id02" input.bcf.gz chr1:100000-20000
}
\examples{
library('vcfppR')
svfile <- system.file("extdata", "sv.vcf.gz", package="vcfppR")
res <- vcfsummary(svfile, region = "chr21:1-10000000", svtype = TRUE)
str(res)
}
\author{
Zilong Li \email{zilong.dk@gmail.com}
}
