% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{fullSVC_line}
\alias{fullSVC_line}
\title{Sample Function for GP-based SVC Model on Real Line}
\usage{
fullSVC_line(df.pars, nugget.sd, locs)
}
\arguments{
\item{df.pars}{(\code{data.frame(p, 3)}) \cr
Contains the mean and covariance parameters of SVCs. The four columns
must have the names \code{"mean"}, \code{"nu"}, \code{"var"}, and
\code{"scale"}.}

\item{nugget.sd}{(\code{numeric(1)}) \cr
Standard deviation of the nugget / error term.}

\item{locs}{(\code{numeric(n)}) \cr
The vector contains the observation locations and therefore defines the
number of observations to be \code{n}.}
}
\value{
\code{list} \cr
   Returns a list with the response \code{y}, model matrix
   \code{X}, a matrix \code{beta} containing the sampled SVC at given
   locations, a vector \code{eps} containing the error, and a vector
   \code{locs} containing the original locations.
}
\description{
Samples SVC data on a real line. The SVCs parameters and the
sample locations have to be provided. The SVCs are assumed to have an
Matern covariance function. The sampled model matrix contains an
intercept as a first column and further covariates sampled from a standard
normal. The SVCs are sampled according to their given parametrization and at
respective observation locations. The error vector sampled from a nugget
effect. Finally, the response vector is computed.
}
\examples{
set.seed(123)
# SVC parameters
(df.pars <- data.frame(
   nu = c(1.5, 1.5),
   var = c(2, 1),
   scale = c(3, 1),
   mean = c(1, 2)))
# nugget standard deviation
tau <- 0.5

# sample locations
s <- sort(runif(500, min = 0, max = 10))
SVCdata <- fullSVC_line(
  df.pars = df.pars,
  nugget.sd = tau,
  locs = s
)

}
