"SVAR" <-
function(x, Amat = NULL, Bmat = NULL, start = NULL, ...){
  ## testing of valid arguments
  if(!class(x)=="varest"){
    stop("\nPlease, provide an object of class 'varest',\n generated by function 'VAR()' as input for 'x'.\n")}
  if((is.null(Amat)) && (is.null(Bmat))){
    stop("\nAt least one matrix, either 'Amat' or 'Bmat', must be non-null.\n")
  }
  if ((is.null(Amat)) && !(is.null(Bmat))) {
    Amat <- diag(x$K)
    svartype <- "B-model"
  } else if ((is.null(Bmat)) && !(is.null(Amat))) {
    Bmat <- diag(x$K)
    svartype <- "A-model"
  } else {
    svartype <- "AB-model"
  }
  if(!any(is.na(cbind(Amat, Bmat)))){
    stop("\nNo parameters provided for optimisation, i.e.\nneither 'Amat' nor 'Bmat' does contain na-elements.\n")    
  }
  param.Aidx <- which(is.na(Amat), arr.ind=TRUE)
  param.Bidx <- which(is.na(Bmat), arr.ind=TRUE)
  ifelse(!is.null(nrow(param.Aidx)), params.A <- nrow(param.Aidx), params.A <- 0)
  ifelse(!is.null(nrow(param.Bidx)), params.B <- nrow(param.Bidx), params.B <- 0)
  params <- params.A + params.B
  K <- x$K
  obs <- x$obs
  df <- summary(x$varresult[[1]])$df[2]
  sigma <- crossprod(x$resid) / df
  if((svartype == "B-model") || (svartype == "A-model")){
    if(K^2 - params <= K*(K-1)/2){
      stop("\nModel is not identified,\nchoose different settings for 'Amat' and/or 'Bmat'.\n")      
    }
  } else if(svartype == "AB-model"){
    if(2*K^2 - params.A + params.B <= K^2 + K*(K-1)/2){
      stop("\nModel is not identified,\nchoose different settings for 'Amat' and/or 'Bmat'.\n")      
    }
  }
  if(is.null(start)) start <- rep(0.1, params)
  start <- as.vector(start)
  if(!(length(start)==params)){
    stop("\nWrong count of starting values provided in 'start'.\nLength of 'start' must be equal to the count of 'na' in 'Amat' and 'Bmat'.\n")
  }
  logLc <- function(coef){
    if(svartype == "B-model"){
      Bmat[param.Bidx] <- coef
    } else if(svartype == "A-model"){
      Amat[param.Aidx] <- coef
    } else if(svartype == "AB-model"){
      if(length(param.Aidx) > 0){
        Amat[param.Aidx] <- coef[c(1:nrow(param.Aidx))]
        if(length(param.Bidx) > 0){
          Bmat[param.Bidx] <- coef[-c(1:nrow(param.Aidx))]
        }
      } else if(length(param.Aidx) == 0){
        Bmat[param.Bidx] <- coef
      }
    }
    const <- -1*(K*obs/2)*log(2*pi)
    logLc <- const + obs/2*log(det(Amat)^2) - obs/2*log(det(Bmat)^2) - obs/2*sum(diag(t(Amat) %*% solve(t(Bmat)) %*% solve(Bmat) %*% Amat %*% sigma))
    return(-logLc)
  }
  opt <- optim(start, logLc, ...)
  Asigma <- matrix(0, nrow = K, ncol = K)
  Bsigma <- matrix(0, nrow = K, ncol = K)
  if(!(is.null(opt$hessian))){
    Sigma <- sqrt(diag(solve(opt$hessian))) 
  }
  if(svartype == "B-model"){
    Bmat[param.Bidx] <- opt$par
    if(!(is.null(opt$hessian))){
      Bsigma[param.Bidx] <- Sigma
    }
  }else if(svartype == "A-model"){
    Amat[param.Aidx] <- opt$par
    if(!(is.null(opt$hessian))){
      Asigma[param.Aidx] <- Sigma
    }
  }else if(svartype == "AB-model"){
    if(length(param.Aidx) > 0){
      Amat[param.Aidx] <- head(opt$par, nrow(param.Aidx))
      if(!(is.null(opt$hessian))){
        Asigma[param.Aidx] <- head(Sigma, nrow(param.Aidx))
      }
    } else {
      Amat <-  Amat
    }
    if(length(param.Bidx) > 0){
      Bmat[param.Bidx] <- tail(opt$par, nrow(param.Bidx))
      if(!(is.null(opt$hessian))){
        Bsigma[param.Bidx] <- tail(Sigma, nrow(param.Bidx))
      }
    } else {
      Bmat <-  Bmat
    }
  }
  colnames(Amat) <- colnames(x$y)
  rownames(Amat) <- colnames(Amat)
  colnames(Bmat) <- colnames(Amat)
  rownames(Bmat) <- colnames(Amat)
  colnames(Asigma) <- colnames(Amat)
  rownames(Asigma) <- colnames(Amat)
  colnames(Bsigma) <- colnames(Amat)
  rownames(Bsigma) <- colnames(Amat)  
  Sigma.U <- solve(Amat)%*%Bmat%*%t(Bmat)%*%t(solve(Amat))
  STATISTIC <- obs*(log(det(Sigma.U)) - log(det(sigma)))
  names(STATISTIC) <- "Chi^2"
  PARAMETER <- 2*K^2 - params - 2*K^2 + 0.5 * K * (K + 1)
  names(PARAMETER) <- "df"
  PVAL <- 1 - pchisq(STATISTIC, df = PARAMETER)
  METHOD <- "LR overidentification"
  LRover <- list(statistic = STATISTIC, parameter = PARAMETER, p.value = PVAL, method = METHOD, data.name = deparse(substitute(x)))
  class(LRover) <- "htest"
  result <- list(A = Amat, Ase = Asigma, B = Bmat, Bse = Bsigma, LRIM = NULL, Sigma.U = Sigma.U*100, LR = LRover, opt = opt, start = start, type = svartype, var = x, call=match.call())
  class(result) <- "svarest"
  return(result)
}
