% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructionModelesLassoRank.R
\name{constructionModelesLassoRank}
\alias{constructionModelesLassoRank}
\title{constructionModelesLassoRank}
\usage{
constructionModelesLassoRank(
  S,
  k,
  mini,
  maxi,
  X,
  Y,
  eps,
  rank.min,
  rank.max,
  ncores,
  fast,
  verbose
)
}
\arguments{
\item{S}{output of selectVariables.R}

\item{k}{number of components}

\item{mini}{integer, minimum number of iterations in the EM algorithm, by default = 10}

\item{maxi}{integer, maximum number of iterations in the EM algorithm, by default = 100}

\item{X}{matrix of covariates (of size n*p)}

\item{Y}{matrix of responses (of size n*m)}

\item{eps}{real, threshold to say the EM algorithm converges, by default = 1e-4}

\item{rank.min}{integer, minimum rank in the low rank procedure, by default = 1}

\item{rank.max}{integer, maximum rank in the low rank procedure, by default = 5}

\item{ncores}{Number of cores, by default = 3}

\item{fast}{TRUE to use compiled C code, FALSE for R code only}

\item{verbose}{TRUE to show some execution traces}
}
\value{
a list with several models, defined by phi (the regression parameter reparametrized),
rho (the covariance parameter reparametrized), pi (the proportion parameter is the mixture model), llh
(the value of the loglikelihood function for this estimator on the training dataset). The list is given
for several levels of sparsity, given by several regularization parameters computed automatically,
and several ranks (between rank.min and rank.max).
}
\description{
Construct a collection of models with the Lasso-Rank procedure.
}
