% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionset.R, R/confrontation.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,expressionset-method}
\alias{summary,indication-method}
\alias{summary,validation-method}
\alias{validate-summary}
\title{Create a summary}
\usage{
summary(object, ...)

\S4method{summary}{expressionset}(object, ...)

\S4method{summary}{indication}(object, ...)

\S4method{summary}{validation}(object, ...)
}
\arguments{
\item{object}{An R object}

\item{...}{Currently unused}
}
\value{
A \code{data.frame} with the information mentioned below is returned.
}
\description{
Create a summary
}
\section{Validator and indicator objects}{

For these objects, the ruleset is split into subsets (blocks) that are disjunct in the
sense that they do not share any variables. For each bloch the number of variables, the number 
of rules and the number of rules that are linear are reported.
}

\section{Indication}{

Some basic information per evaluated indicator is reported: the number of items to which the 
indicator was applied, the output \code{class}, some statistics (min, max, mean , number of NA)
and wether an exception occurred (warnings or errors). The evaluated expression is reported as well.
}

\section{Validation}{

Some basic information per evaluated validation rule is reported: the number of items to which the 
rule was applied, the output \code{class}, some statistics (passes, fails, number of NA)
and wether an exception occurred (warnings or errors). The evaluated expression is reported as well.
}
\examples{
data(retailers)
v <- validator(staff > 0, staff.costs/staff < 20, turnover+other.revenue == total.revenue)
summary(v)

cf <- confront(retailers,v)
summary(cf)


}

