% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef_vicc.R
\name{ranef.vicc}
\alias{ranef.vicc}
\alias{ranef}
\title{Extract the Random Effects}
\usage{
\method{ranef}{vicc}(object, cred = 0.9, ...)
}
\arguments{
\item{object}{An object of class \code{vicc}}

\item{cred}{Numeric. Credible interval width (defaults to \code{0.90}).}

\item{...}{Currently ignored.}
}
\value{
An array with the summarized parameters.
}
\description{
Extract the group-specific parameter estimates.
}
\examples{
\donttest{

flanker <- vICC::flanker

# congruent trials
congruent <- subset(flanker, cond == 0)

# subset 25 from each group
dat <- congruent[unlist(tapply(1:nrow(congruent),
                            congruent$id,
                            head, 25)), ]

# fit model
fit <- vicc(y  = dat$rt,
            group = dat$id,
            iter = 250,
            burnin = 10,
            type =  "customary")

ranef(fit)
}
}
