% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_extraction.R
\name{metadata_extraction}
\alias{metadata_extraction}
\title{Metadata Extraction from NCBI/GISAID EpiCoV FASTA file}
\usage{
metadata_extraction(file_path, source)
}
\arguments{
\item{file_path}{path of fasta file}

\item{source}{the source of fasta file, either "ncbi" or "GISAID"}
}
\value{
A dataframe that has three columns consisting ID, collected country and collected date
}
\description{
This function retrieves metadata (ID, country, date) from the input FASTA file, with the source of, either 
NCBI (with default FASTA header) or GISAID (with default FASTA header).
}
\examples{
filepath <- system.file('extdata','GISAID_EpiCoV.faa', package = 'vDiveR')
meta_gisaid <- metadata_extraction(filepath, 'GISAID')
}
