% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utr_analysis.R
\name{getTranscriptIdsForTSSKozakVariants}
\alias{getTranscriptIdsForTSSKozakVariants}
\title{Find the ensembl_transcript_id and kozak_positions for variants in TSS Kozak region (8nt) [AG]..AUGG.}
\usage{
getTranscriptIdsForTSSKozakVariants(variantsTable, transcriptRegions)
}
\arguments{
\item{variantsTable}{variants table}

\item{transcriptRegions}{transcripts structure table from ensembl}
}
\value{
A data table containing two columns: ensembl_transcript_id (id of the transcripts for each variant which its mutation Pos is within TSS Kozak regions)
                                       kozak_positions (positions of each nucleotide in Kozak sequence)
}
\description{
\code{getTranscriptIdsForTSSKozakVariants} get the ensembl_transcript_id and kozak_positions for variants in TSS Kozak region (8nt) [AG]..AUGG.
}
\details{
For each variant, get all transcripts and extract their checkRegion's coordinates. For each transcript, check if the mutation Pos
is within the region, if so, add that transcript's ensembl_transcript_id. If the mutation Pos is within multiple transcripts checkRegions,
the transcripts ids are concatenate into one string with ";".
}
\keyword{internal}
