% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ecc.R
\name{ecc}
\alias{ecc}
\title{Ensemble of Classifier Chains for multi-label Classification}
\usage{
ecc(mdata, base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  m = 10, subsample = 0.75, attr.space = 0.5, replacement = TRUE, ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed", NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{m}{The number of Classifier Chains models used in the ensemble.
(Default: 10)}

\item{subsample}{A value between 0.1 and 1 to determine the percentage of
training instances that must be used for each classifier. (Default: 0.75)}

\item{attr.space}{A value between 0.1 and 1 to determine the percentage of
attributes that must be used for each classifier. (Default: 0.50)}

\item{replacement}{Boolean value to define if use sampling with replacement
to create the data of the models of the ensemble. (Default: TRUE)}

\item{...}{Others arguments passed to the base algorithm for all subproblems.}

\item{cores}{The number of cores to parallelize the training. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{ECCmodel} containing the set of fitted
  CC models, including:
\describe{
  \item{rounds}{The number of interactions}
  \item{models}{A list of BR models.}
  \item{nrow}{The number of instances used in each training dataset}
  \item{ncol}{The number of attributes used in each training dataset}
}
}
\description{
Create an Ensemble of Classifier Chains model for multilabel classification.
}
\details{
This model is composed by a set of Classifier Chains models. Classifier
Chains is a Binary Relevance transformation method based to predict
multi-label data. It is different from BR method due the strategy of extended
the attribute space with the 0/1 label relevances of all previous
classifiers, forming a classifier chain.
}
\note{
If you want to reproduce the same classification and obtain the same
 result will be necessary set a flag utiml.mc.set.seed to FALSE.
}
\examples{
# Use all default values
model <- ecc(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
# Use J48 with 100\% of instances and only 5 rounds
model <- ecc(toyml, 'J48', m = 5, subsample = 1)

# Use 75\% of attributes
model <- ecc(toyml, attr.space = 0.75)

# Running in 4 cores and define a specific seed
model1 <- ecc(toyml, cores=4, seed=123)
}
}
\references{
Read, J., Pfahringer, B., Holmes, G., & Frank, E. (2011). Classifier
   chains for multi-label classification. Machine Learning, 85(3), 333-359.

   Read, J., Pfahringer, B., Holmes, G., & Frank, E. (2009).
   Classifier Chains for Multi-label Classification. Machine Learning and
   Knowledge Discovery in Databases, Lecture Notes in Computer Science,
   5782, 254-269.
}
\seealso{
Other Transformation methods: \code{\link{brplus}},
  \code{\link{br}}, \code{\link{cc}}, \code{\link{clr}},
  \code{\link{ctrl}}, \code{\link{dbr}}, \code{\link{ebr}},
  \code{\link{eps}}, \code{\link{esl}},
  \code{\link{homer}}, \code{\link{lift}},
  \code{\link{lp}}, \code{\link{mbr}}, \code{\link{ns}},
  \code{\link{ppt}}, \code{\link{prudent}},
  \code{\link{ps}}, \code{\link{rakel}},
  \code{\link{rdbr}}, \code{\link{rpc}}

Other Ensemble methods: \code{\link{ebr}},
  \code{\link{eps}}
}
