% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\title{Sample Skewness}
\usage{
skewness(x, skew.type = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{A data vector/matrix}

\item{skew.type}{The type of skewness statistic used ('Moment', 'Fisher Pearson' or 'Adjusted Fisher Pearson')}

\item{na.rm}{Logical value; if \code{TRUE} the function removes \code{NA} values}
}
\value{
The sample skewness of the data vector/matrix
}
\description{
\code{skewness} returns the sample skewness of a data vector/matrix
}
\details{
This function computes the sample skewness for a data vector or matrix.  For a vector input the function returns a single value for the
sample skewness of the data.  For a matrix input the function treats each column as a data vector and returns a vector of values for the
sample skewness of each of these datasets.  The function can compute different types of skewness statistics using the \code{skew.type} input.
}
\examples{

skewness(rnorm(1000))
skewness(rexp(1000))

}
