% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns_triphasic.R
\name{get_triphasic}
\alias{get_triphasic}
\title{Compute the triphasic model curve}
\usage{
get_triphasic(params, timevec)
}
\arguments{
\item{params}{named numeric vector of all parameters needed to compute the triphasic model, V(t)}

\item{timevec}{numeric vector of the times, t, at which V(t) should be calculated}
}
\value{
numeric vector of viral load predictions, V(t), for each time point in 'timevec'
}
\description{
This function calculates the triphasic model, V(t), for a vector of input times, t
}
\examples{

get_triphasic(params = c(A = 10000, delta = 1, B = 1000, gamma = 0.1, C = 100, omega = 0.03),
             timevec = seq(1, 100, length.out = 100))

}
