% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/course.R
\name{use_course_details}
\alias{use_course_details}
\title{Download and unpack a ZIP file}
\arguments{
\item{url}{Download link for the ZIP file, possibly behind a shortlink or
other redirect. See Details.}

\item{destdir}{Path to existing local directory where the ZIP file will be
stored. Defaults to current working directory, but note that \code{\link[=use_course]{use_course()}}
has different default behavior.}

\item{pedantic}{Logical. When \code{TRUE} and in an interactive session, the user
is told where the ZIP file will be stored. If happy, user can elect to
proceed. Otherwise, user can abort and try again with the desired
\code{destdir}. Intentional friction for a pedagogical setting.}

\item{zipfile}{Path to local ZIP file.}
}
\description{
Details on the two functions that power \code{\link[=use_course]{use_course()}}. These internal
functions are currently unexported but a course instructor may want more
details.
}
\section{download_zip()}{
\preformatted{## function signature
download_zip(url, destdir = getwd(), pedantic = FALSE)

## as called inside use_course()
download_zip(
  url, ## after post-processing with normalize_url()
  ## conspicuous_place() = Desktop or home directory or working directory
  destdir = destdir \\\%||\\\% conspicuous_place(),
  pedantic = is.null(destdir) && interactive()
)
}

Special-purpose function to download a ZIP file and automatically determine
the file name, which often determines the folder name after unpacking.
Developed with DropBox and GitHub as primary targets, possibly via
shortlinks. Both platforms offer a way to download an entire folder or repo
as a ZIP file, with information about the original folder or repo transmitted
in the \code{Content-Disposition} header. In the absence of this header, a
filename is generated from the input URL. In either case, the filename is
sanitized. Returns the path to downloaded ZIP file, invisibly.

\strong{DropBox:}

To make a folder available for ZIP download, create a shared link for it:
\itemize{
\item \url{https://www.dropbox.com/help/files-folders/view-only-access}
}

A shared link will have this form:\preformatted{https://www.dropbox.com/sh/12345abcde/6789wxyz?dl=0
}

Replace the \code{dl=0} at the end with \code{dl=1} to create a download link. The ZIP
download link will have this form:\preformatted{https://www.dropbox.com/sh/12345abcde/6789wxyz?dl=1
}

This download link (or a shortlink that points to it) is suitable as input
for \code{download_zip()}. After one or more redirections, this link will
eventually lead to a download URL. For more details, see
\url{https://www.dropbox.com/help/desktop-web/force-download} and
\url{https://www.dropbox.com/en/help/desktop-web/download-entire-folders}.

\strong{GitHub:}

Click on the repo's "Clone or download" button, to reveal a "Download ZIP"
button. Capture this URL, which will have this form:\preformatted{https://github.com/r-lib/usethis/archive/master.zip
}

This download link (or a shortlink that points to it) is suitable as input
for \code{download_zip()}. After one or more redirections, this link will
eventually lead to a download URL. Here's an alternative link that also leads
to ZIP download, albeit with a different filenaming scheme:\preformatted{https://api.github.com/repos/r-lib/usethis/zipball/master
}
}

\section{tidy_unzip()}{


Special-purpose function to unpack a ZIP file and (attempt to) create the
directory structure most people want. When unpacking an archive, it is easy
to get one more or one less level of nesting than you expected.

It's especially important to finesse the directory structure here: we want
the same local result when unzipping the same content from either GitHub or
DropBox ZIP files, which pack things differently. Here is the intent:
\itemize{
\item If the ZIP archive \code{foo.zip} does not contain a single top-level directory,
i.e. it is packed as "loose parts", unzip into a directory named \code{foo}.
Typical of DropBox ZIP files.
\item If the ZIP archive \code{foo.zip} has a single top-level directory (which, by
the way, is not necessarily called "foo"), unpack into said directory.
Typical of GitHub ZIP files.
}

Returns path to the directory holding the unpacked files, invisibly.

\strong{DropBox:}
The ZIP files produced by DropBox are special. The file list tends to contain
a spurious directory \code{"/"}, which we ignore during unzip. Also, if the
directory is a Git repo and/or RStudio Project, we unzip-ignore various
hidden files, such as \code{.RData}, \code{.Rhistory}, and those below \code{.git/} and
\code{.Rproj.user}.
}

\examples{
\dontrun{
download_zip("https://github.com/r-lib/rematch2/archive/master.zip")
}

\dontrun{
download_zip("https://github.com/r-lib/rematch2/archive/master.zip")
tidy_unzip("rematch2-master.zip")
}
}
\seealso{
Other download functions: \code{\link{use_course}}
}
\keyword{internal}
