% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{fromDataFrame}
\alias{fromDataFrame}
\title{extract the sets from a data frame (rows = elems, columns = sets, cell = contained)}
\usage{
fromDataFrame(
  upsetjs,
  df,
  attributes = NULL,
  order.by = "cardinality",
  limit = NULL,
  shared = NULL,
  shared.mode = "click",
  colors = NULL
)
}
\arguments{
\item{upsetjs}{an object of class \code{upsetjs} or \code{upsetjs_proxy}}

\item{df}{the data.frame like structure}

\item{attributes}{the optional column list or data frame}

\item{order.by}{order intersections by cardinality or degree}

\item{limit}{limit the ordered sets to the given limit}

\item{shared}{a crosstalk shared data frame}

\item{shared.mode}{whether on 'hover' or 'click' (default) is synced}

\item{colors}{the optional list with set name to color}
}
\value{
the object given as first argument
}
\description{
extract the sets from a data frame (rows = elems, columns = sets, cell = contained)
}
\examples{
df <- as.data.frame(list(a=c(1, 1, 1),b=c(0, 1, 1)),row.names=c('a', 'b', 'c'))
upsetjs() \%>\% fromDataFrame(df)

}
