% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esr.R
\name{esr}
\alias{esr}
\title{Effective Sampling Rate}
\usage{
esr(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A number between 0 and 1 indicating the esr value.
}
\description{
Calculates the effective sampling rate (\code{esr}).
}
\details{
By default
\deqn{\frac{1}{1 + 2 \sum_{k = 1}^\infty\rho_k(\theta)}}
from Brooks et al. (2011) where the infinite sum is truncated at
lag \eqn{k} when \eqn{\rho_{k+1}(\theta) < 0}.
}
\examples{
esr.foobar <- function(x, ...) {
  NotYetImplemented()
  # replace with code to get esr for an object of class 'foobar'
}
}
\references{
Brooks, S., Gelman, A., Jones, G.L., and Meng, X.-L. (Editors). 2011.
Handbook for Markov Chain Monte Carlo. Taylor & Francis, Boca Raton.
}
\seealso{
Other convergence: 
\code{\link{converged_pars}()},
\code{\link{converged_terms}()},
\code{\link{converged}()},
\code{\link{esr_pars}()},
\code{\link{esr_terms}()},
\code{\link{rhat_pars}()},
\code{\link{rhat_terms}()},
\code{\link{rhat}()}
}
\concept{convergence}
