% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitedRoverview.R
\name{overview}
\alias{overview}
\title{Overview over the parameters used in the \code{unitedR} package}
\arguments{
\item{away}{away team (an object of the \code{S4}class \code{formation})}

\item{DF}{\code{numeric} vector for the strengths of the players in the 
defense}

\item{formation}{object of the \code{S4}class \code{formation}}

\item{GK}{\code{integer} for the strength goalkeeper}

\item{hardness}{\code{numeric} vector of length five with integers for the used hardness}

\item{hardnessMatrix}{\code{matrix} matrix with eleven columns which contain the probability 
for yellow cards dependent on the used hardness}

\item{home}{home team (an object of the \code{S4}class \code{formation})}

\item{homeAdv}{\code{numeric} vector of length five with integers for the used hardness}

\item{MF}{\code{numeric} vector for the strengths of the players in the 
midfield}

\item{penaltyGoalProb}{probability of a goal by a singular penalty}

\item{penaltyProb}{occurrence probability of a penalty}

\item{posPenalties}{number of possible penalties in a game}

\item{preventGoalGK}{factor multiplicied with the strength of the GK for computing the 
probability of preventing a goal by the goalkeeper}

\item{preventGoalSW}{factor multiplicied with the strength of the SW for computing the 
probability of preventing a goal by the sweeper}

\item{r}{number of replications for the simulation of hardness and penalties, can 
be \code{missing} (exact results will be computed)}

\item{ST}{\code{numeric} vector of integers for the strenghts of the strikers}

\item{SW}{\code{vector} for the strength of the sweeper, can be 
\code{NA} or a \code{numeric}}

\item{x}{a variable \code{x}.}
}
\description{
This list of parameters yields a comprehensive overview of the parameters
used in the \code{unitedR} package.
}
