% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_box_calls.R
\name{slide}
\alias{slide}
\title{Plot a slide (or frame).}
\usage{
slide(col = NA, dim = c(4/3, 1), border = grey(0.33, 1), lwd = 1.5)
}
\arguments{
\item{col}{The color to fill the slide with (i.e., its background color).
Default: \code{col = NA} (i.e., system default for transparency).}

\item{dim}{The x- and y-dimensions of the slide. 
Default: \code{dim = c(4/3, 1)} (i.e., unit height, 4/3 wider than high).}

\item{border}{The color of the slide's border. 
Setting \code{border = NA} hides border.  
Default: \code{border = grey(.33, 1)}.}

\item{lwd}{The line width of the slide's border. 
Setting \code{lwd = 0} or \code{lwd = NA} removes border. 
Default: \code{lwd = 1.5}.}
}
\description{
\code{slide} plots an empty slide (or frame) 
as a colored rectangle.
}
\examples{
slide()  # default slide (or frame)
slide(lwd = NA)  # borderless slide

# Dimensions: 
slide(dim = c(18, 9))  # larger and 2:1 dimensions

# Formatting:
slide(col = pal_seeblau[[1]], border = pal_seeblau[[5]], lwd = 2)

}
\seealso{
\code{\link{heading}}, \code{\link{line}}, or \code{\link{mark}} to add text to a slide;  
\code{\link{xbox}} to plot a box.

Other plot functions: \code{\link{theme_unikn}},
  \code{\link{xbox}}
}
\concept{plot functions}
