% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unigd.R
\name{ugd}
\alias{ugd}
\title{A unified R graphics backend.}
\usage{
ugd(
  width = getOption("unigd.width", 720),
  height = getOption("unigd.height", 576),
  bg = getOption("unigd.bg", "white"),
  pointsize = getOption("unigd.pointsize", 12),
  system_fonts = getOption("unigd.system_fonts", list()),
  user_fonts = getOption("unigd.user_fonts", list()),
  reset_par = getOption("unigd.reset_par", FALSE)
)
}
\arguments{
\item{width}{Graphics device width (pixels).}

\item{height}{Graphics device height (pixels).}

\item{bg}{Background color.}

\item{pointsize}{Graphics device point size.}

\item{system_fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol}
are aliased to the family returned by
\code{\link[systemfonts:font_info]{systemfonts::font_info()}}.}

\item{user_fonts}{Named list of fonts to be aliased with font files
provided by the user rather than fonts properly installed on the
system. The aliases can be fonts from the fontquiver package,
strings containing a path to a font file, or a list containing
\code{name} and \code{file} elements with \code{name} indicating
the font alias in the SVG output and \code{file} the path to a
font file.}

\item{reset_par}{If set to \code{TRUE}, global graphics parameters will be saved
on device start and reset every time \code{\link[=ugd_clear]{ugd_clear()}} is called (see
\code{\link[graphics:par]{graphics::par()}}).}
}
\value{
No return value, called to initialize graphics device.
}
\description{
This function initializes a unigd graphics device.
}
\details{
All font settings and descriptions are adopted from the excellent
'svglite' package.
}
\examples{
ugd() # Initialize graphics device

# Plot something
x <- seq(0, 3 * pi, by = 0.1)
plot(x, sin(x), type = "l")

# Render plot as SVG
ugd_render(width = 600, height = 400, as = "svg")

dev.off() # alternatively: ugd_close()
}
