% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifed.kappa.R
\name{unifed.kappa}
\alias{unifed.kappa}
\alias{unifed.kappa.prime}
\alias{unifed.kappa.double.prime}
\alias{unifed.kappa.prime.inverse}
\alias{unifed.kappa.prime.inverse.one}
\title{Cumulant generator of the unifed distribution}
\usage{
unifed.kappa(theta)

unifed.kappa.prime(theta)

unifed.kappa.double.prime(theta)

unifed.kappa.prime.inverse(mu, ...)

unifed.kappa.prime.inverse.one(mu, tol = 1e-07, maxit = 1e+07)
}
\arguments{
\item{theta}{A numeric vector.}

\item{mu}{A vector of numbers between 0 and 1}

\item{...}{Other parameters of \code{\link{unifed.kappa.prime.inverse.one}}}

\item{tol}{Tolerance level. The algorithm stops if the proportional
difference between the new and old value of an iteration is
less or equal than this number.}

\item{maxit}{Maximum number of iterations of the algorithm to look
for convergence.}
}
\value{
\code{unifed.kappa} returns a vector that contains the
    cumulant generator of the unifed distribution applied to each
    element of theta.

\code{unifed.kappa.prime} returns a vector that contains
    the derivative of the cumulant generator of the unifed
    distribution for each element of theta.

\code{unifed.kappa.double.prime} returns a vector that
    contains the second derivative of the cumulant generator of the
    unifed distribution for each element of theta.

\code{unifed.kappa.prime.inverse} returns a vector with
    \code{unifed.kappa.prime.inverse.one} evaluated at every entry
    of \code{mu}.

\code{unifed.kappa.prime.inverse.one} if the tolerance
    level is reached within \code{maxit} iterations, the function
    returns the value of the last iteration. Otherwise it returns
    \code{NA}.
}
\description{
Cumulant generator of the unifed distribution
}
\details{
The cumulant generator of the unifed distribution is
    defined as

\deqn{
\kappa(\theta)=\left\{
  \begin{array}{ll}
    \log\left(\frac{e^\theta-1}{\theta}\right)& if \theta \neq
                                                0\\
    0 & \mbox{if }\theta=0
  \end{array}
  \right..}{                     /                                       
                    |     / theta    \                      
                    |     |e      - 1|                      
kappa(theta) =      | log |----------|   if theta ! =   0   
                    |     \   theta  /                      
                    |                                       
                     \  0                 if theta = 0  

}

\code{unifed.kappa.prime.inverse.one} uses the
    Newthon-Raphson method for finding the inverse of
    \code{unifed.kappa.prime} for a single value.
}
\examples{

unifed.kappa(1)
unifed.kappa(-5:5)


unifed.kappa.prime(4.5)


unifed.kappa.double.prime(0)


unifed.kappa.prime.inverse(0.5)
unifed.kappa.prime.inverse(c(0.1,0.7,0.9))


}
\references{
{
Quijano Xacur, Oscar Alberto (2018). The Unifed Distribution. ArXiv. \url{http://arxiv.org/abs/1812.00251}.

Jørgensen, Bent (1997). The  Theory  of  Dispersion  Models.
Chapman  &  Hall, London.
}
}
