% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pclm_control.R
\name{control.pclm2D}
\alias{control.pclm2D}
\title{Auxiliary for Controlling \code{pclm2D} Fitting}
\usage{
control.pclm2D(lambda     = c(1, 1),
               kr         = 7,
               deg        = 3,
               int.lambda = c(0.1, 1e+3),
               diff       = 2,
               opt.method = c("BIC", "AIC"),
               max.iter   = 1e+3,
               tol        = 1e-3)
}
\arguments{
\item{lambda}{Smoothing parameter to be used in pclm estimation.
If \code{lambda = NA} an algorithm will find the optimal values.}

\item{kr}{Knot ratio. Number of internal intervals used for defining 1 knot in 
B-spline basis construction. See \code{\link{MortSmooth_bbase}}.}

\item{deg}{Degree of the splines needed to create equally-spaced B-splines 
basis over an abscissa of data.}

\item{int.lambda}{If \code{lambda} is optimized an interval to be searched 
needs to be specified. Format: vector containing the end-points.}

\item{diff}{An integer indicating the order of differences of the components 
of PCLM coefficients. Default value: 2.}

\item{opt.method}{Selection criterion of the model.
Possible values are \code{"AIC"} and \code{"BIC"}. Default: \code{"BIC"}.}

\item{max.iter}{Maximal number of iterations used in fitting procedure.}

\item{tol}{Relative tolerance in PCLM fitting procedure. Default: 0.1\% i.e. 
the estimated aggregate bins should be in the 0.1\% error margin.}
}
\value{
A list with exactly eight control parameters.
}
\description{
Auxiliary for Controlling \code{pclm2D} Fitting
}
\examples{
control.pclm2D()
}
\seealso{
\code{\link{pclm2D}}
}
