% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxCI_boot}
\alias{umxCI_boot}
\title{umxCI_boot}
\usage{
umxCI_boot(model, rawData = NULL, type = c("par.expected",
  "par.observed", "empirical"), std = TRUE, rep = 1000, conf = 95,
  dat = FALSE, digits = 3)
}
\arguments{
\item{model}{is an optimized mxModel}

\item{rawData}{is the raw data matrix used to estimate model}

\item{type}{is the kind of bootstrap you want to run. "par.expected" and "par.observed" 
use parametric Monte Carlo bootstrapping based on your expected and observed covariance matrices, respectively.
"empirical" uses empirical bootstrapping based on rawData.}

\item{std}{specifies whether you want CIs for unstandardized or standardized parameters (default: std = TRUE)}

\item{rep}{is the number of bootstrap samples to compute (default = 1000).}

\item{conf}{is the confidence value (default = 95)}

\item{dat}{specifies whether you want to store the bootstrapped data in the output (useful for multiple analyses, such as mediation analysis)}

\item{digits}{rounding precision}
}
\value{
- expected covariance matrix
}
\description{
Compute boot-strapped Confidence Intervals for parameters in an \code{\link{mxModel}}
The function creates a sampling distribution for parameters by repeatedly drawing samples
with replacement from your data and then computing the statistic for each redrawn sample.
}
\examples{
\dontrun{
	require(umx)
	data(demoOneFactor)
	latents  = c("G")
	manifests = names(demoOneFactor)
	m1 <- mxModel("One Factor", type = "RAM", 
		manifestVars = manifests, latentVars = latents, 
		mxPath(from = latents, to = manifests),
		mxPath(from = manifests, arrows = 2),
		mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
		mxData(cov(demoOneFactor), type = "cov", numObs = 500)
	)
	m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
	umxCI_boot(m1, type = "par.expected")
}
}
\references{
- \url{https://openmx.ssri.psu.edu/thread/2598}
Original written by \url{https://openmx.ssri.psu.edu/users/bwiernik}
}
\seealso{
- \code{\link{umxExpMeans}}, \code{\link{umxExpCov}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
\concept{Reporting functions}
