% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_get_cores}
\alias{umx_get_cores}
\title{umx_get_cores}
\usage{
umx_get_cores(model = NULL)
}
\arguments{
\item{model}{an (optional) model to get from. If left NULL, the global option is returned}
}
\value{
- number of cores
}
\description{
Gets the number of cores (threads) used by OpenMx.
}
\examples{
library(umx)
manifests = c("mpg", "disp", "gear")
m1 <- mxModel("ind", type = "RAM",
	manifestVars = manifests,
	mxPath(from = manifests, arrows = 2),
	mxPath(from = "one", to = manifests),
	mxData(mtcars[, manifests], type = "raw")
)
oldCores = umx_get_cores()   # get current default value
umx_set_cores(model = m1)    # set to default (max - 1)
umx_get_cores(model = m1)    # show new value
umx_set_cores() # set to default (max - 1)
umx_get_cores()              # show new value
umx_set_cores(oldCores)      # reset to old value
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Get and set: \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_optimizer}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimizer}}
}

