% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_set_checkpoint}
\alias{umx_checkpoint}
\alias{umx_set_checkpoint}
\title{umx_set_checkpoint}
\usage{
umx_set_checkpoint(interval = 1, units = c("evaluations", "iterations",
  "minutes"), prefix = "", directory = getwd(), model = NULL)
}
\arguments{
\item{interval}{How many units between checkpoints: Default =  1.
A value of zero sets always to 'No' (i.e., do not checkpoint all models during optimization)}

\item{units}{units to count in: Default unit is 'evaluations' ('minutes' is also legal)}

\item{prefix}{string prefix to add to all checkpoint filenames (default = "")}

\item{directory}{a directory, i.e "~/Desktop" (defaults to getwd())}

\item{model}{(optional) model to set options in (default = NULL)}
}
\value{
- mxModel if provided
}
\description{
Set the checkpoint status for a model or global options
}
\examples{
umx_set_checkpoint(interval = 1, "evaluations", dir = "~/Desktop/")
# turn off checkpointing with interval = 0
umx_set_checkpoint(interval = 0)
umx_set_checkpoint(2, "evaluations", prefix="SNP_1")
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)
m1 = umx_set_checkpoint(model = m1)
m1 = mxRun(m1)
umx_checkpoint(0)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_paste_names}}; \code{\link{umx_print}};
  \code{\link{umx_rename}}; \code{\link{umx_reorder}};
  \code{\link{umx_rot}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

