% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nice_tidy}
\alias{nice_tidy}
\title{V4-V5 16S rRNA gene amplicons, clean OTU table in tidy/long format (N-ICE, 2015)}
\format{
\subsection{\code{nice_tidy}}{

A data frame with 4716 rows and 10 columns:
\describe{
\item{Sample}{Sample ID}
\item{Abundance}{Abundance}
\item{OTU}{OTU ID}
\item{Domain}{Domain level classification of OTU}
\item{Phylum}{Domain level classification of OTU}
\item{Class}{Domain level classification of OTU}
\item{Order}{Domain level classification of OTU}
\item{Family}{Domain level classification of OTU}
\item{Genus}{Domain level classification of OTU}
\item{Species}{Domain level classification of OTU}
...
}
}
}
\source{
\url{https://www.ebi.ac.uk/metagenomics/studies/MGYS00001922#analysis}
}
\usage{
nice_tidy
}
\description{
Original OTU table (\link{nice}) in "long" format.
}
\details{
A new column (Sample) includes the sample identifiers and a new column
(Abundance) includes the abundance for each OTU.
For details on OTU table processing see help pages for \link{nice} and \link{nice_raw}.

Some details on N-ICE dataset:

This dataset resulted from the Norwegian Young Sea Ice expedition (N-ICE)
in 2015 (Granskog et al., 2018). The sample processing and DNA sequencing
were described in de Sousa et al., 2019, the bioinformatic processing was
performed by the MGnify platform (v5) (Mitchell et al., 2020).

Since the purpose of this dataset if for creating examples and testing the package,
we did not apply strict quality control to the final OTU table. Thus, we
didn't remove singletons, etc. However, we did remove any
non-prokarotic OTUs and organelles, if any (Pascoal et al., 2022).
}
\references{
\itemize{
\item Mitchell, A. L., Almeida, A., Beracochea, M., Boland, M., Burgin, J., Cochrane, G., Crusoe, M. R., Kale, V., Potter, S. C., Richardson, L. J., Sakharova, E., Scheremetjew, M., Korobeynikov, A., Shlemov, A., Kunyavskaya, O., Lapidus, A., & Finn, R. D. (2019). MGnify: the microbiome analysis resource in 2020. Nucleic Acids Research, 48(D1), D570–D578.
\item Granskog, M. A., Fer, I., Rinke, A., & Steen, H. (2018). Atmosphere-Ice-Ocean-Ecosystem Processes in a Thinner Arctic Sea Ice Regime: The Norwegian Young Sea ICE (N-ICE2015) Expedition. Journal of Geophysical Research: Oceans, 123(3), 1586–1594.
\item de Sousa, A. G. G., Tomasino, M. P., Duarte, P., Fernández-Méndez, M., Assmy, P., Ribeiro, H., Surkont, J., Leite, R. B., Pereira-Leal, J. B., Torgo, L., & Magalhães, C. (2019). Diversity and Composition of Pelagic Prokaryotic and Protist Communities in a Thin Arctic Sea-Ice Regime. Microbial Ecology, 78(2), 388–408.
\item Pascoal, F., Costa, R., Assmy, P., Duarte, P., & Magalhães, C. (2022). Exploration of the Types of Rarity in the Arctic Ocean from the Perspective of Multiple Methodologies. Microbial Ecology, 84(1), 59–72.
}
}
\seealso{
\code{\link[=nice]{nice()}}, \link{nice_raw}, \link{nice_env}
}
\keyword{datasets}
