% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multinomPois.R
\name{stan_multinomPois}
\alias{stan_multinomPois}
\title{Fit the Multinomial-Poisson Mixture Model}
\usage{
stan_multinomPois(formula, data, ...)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and abundance in that order}

\item{data}{A \code{\link{unmarkedFrameMPois}} object}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitMultinomPois} object describing the model fit.
}
\description{
This function fits the multinomial-Poisson mixture model, useful for
data collected via survey methods such as removal or double observer sampling.
}
\examples{
\donttest{
data(ovendata)
ovenFrame <- unmarkedFrameMPois(ovendata.list$data,
                                siteCovs=ovendata.list$covariates,
                                type="removal")

oven_fit <- stan_multinomPois(~1~scale(ufc), ovenFrame, chains=3, iter=300)
}

}
\seealso{
\code{\link{multinomPois}}, \code{\link{unmarkedFrameMPois}}
}
