% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{run_simulation_ubiquity}
\alias{run_simulation_ubiquity}
\title{Simulate Individual Response}
\usage{
run_simulation_ubiquity(SIMINT_parameters, SIMINT_cfg, SIMINT_dropfirst = TRUE)
}
\arguments{
\item{SIMINT_parameters}{vector of parameters}

\item{SIMINT_cfg}{ubiquity system object}

\item{SIMINT_dropfirst}{when \code{TRUE} it will drop the first sample point (prevents bolus doses from starting at 0)}
}
\value{
The simulation output is mapped (\code{som}) is a list.
time-course is stored in the \code{simout} element. 
\itemize{
\item The first column (\code{time}) contains the simulation time in the units of the simulation. 
\item Next there is a column for each: State, output and system parameter   
\item Models with covariate will contain the initial value  (prefix: \code{SIMINT_CVIC_}) as well as the values at each time point
\item Each static and dynamic system parameter is also passed through
\item A column for each timescale is returned with a "\code{ts.}" prefix.
}
}
\description{
Controls the execution of individual simulations with deSolve using either R scripts or loadable C libraries.
}
\seealso{
Simulation vignette (\code{vignette("Simulation", package = "ubiquity")})
}
